package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NextToken, NumberResults}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BatchListIndex(
    rangesOnIndexedValues: Optional[
      Iterable[zio.aws.clouddirectory.model.ObjectAttributeRange]
    ] = Optional.Absent,
    indexReference: zio.aws.clouddirectory.model.ObjectReference,
    maxResults: Optional[NumberResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListIndex = {
    import BatchListIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListIndex
      .builder()
      .optionallyWith(
        rangesOnIndexedValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rangesOnIndexedValues)
      .indexReference(indexReference.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchListIndex.ReadOnly =
    zio.aws.clouddirectory.model.BatchListIndex.wrap(buildAwsValue())
}
object BatchListIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchListIndex =
      zio.aws.clouddirectory.model.BatchListIndex(
        rangesOnIndexedValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        indexReference.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def rangesOnIndexedValues: Optional[
      List[zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly]
    ]
    def indexReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def maxResults: Optional[NumberResults]
    def nextToken: Optional[NextToken]
    def getRangesOnIndexedValues: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly
    ]] =
      AwsError.unwrapOptionField("rangesOnIndexedValues", rangesOnIndexedValues)
    def getIndexReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(indexReference)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListIndex
  ) extends zio.aws.clouddirectory.model.BatchListIndex.ReadOnly {
    override val rangesOnIndexedValues: Optional[
      List[zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rangesOnIndexedValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.ObjectAttributeRange.wrap(item)
        }.toList
      )
    override val indexReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.indexReference())
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListIndex
  ): zio.aws.clouddirectory.model.BatchListIndex.ReadOnly = new Wrapper(impl)
}
