package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{SchemaJsonDocument, SchemaName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSchemaAsJsonResponse(
    name: Optional[SchemaName] = Optional.Absent,
    document: Optional[SchemaJsonDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse = {
    import GetSchemaAsJsonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse
      .builder()
      .optionallyWith(
        name.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        document.map(value =>
          SchemaJsonDocument.unwrap(value): java.lang.String
        )
      )(_.document)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.wrap(buildAwsValue())
}
object GetSchemaAsJsonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetSchemaAsJsonResponse =
      zio.aws.clouddirectory.model.GetSchemaAsJsonResponse(
        name.map(value => value),
        document.map(value => value)
      )
    def name: Optional[SchemaName]
    def document: Optional[SchemaJsonDocument]
    def getName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("name", name)
    def getDocument: ZIO[Any, AwsError, SchemaJsonDocument] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse
  ) extends zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly {
    override val name: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.clouddirectory.model.primitives.SchemaName(value))
    override val document: Optional[SchemaJsonDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.SchemaJsonDocument(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse
  ): zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly =
    new Wrapper(impl)
}
