package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchReadOperation(
    listObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchListObjectAttributes
    ] = Optional.Absent,
    listObjectChildren: Optional[
      zio.aws.clouddirectory.model.BatchListObjectChildren
    ] = Optional.Absent,
    listAttachedIndices: Optional[
      zio.aws.clouddirectory.model.BatchListAttachedIndices
    ] = Optional.Absent,
    listObjectParentPaths: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentPaths
    ] = Optional.Absent,
    getObjectInformation: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectInformation
    ] = Optional.Absent,
    getObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectAttributes
    ] = Optional.Absent,
    listObjectParents: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParents
    ] = Optional.Absent,
    listObjectPolicies: Optional[
      zio.aws.clouddirectory.model.BatchListObjectPolicies
    ] = Optional.Absent,
    listPolicyAttachments: Optional[
      zio.aws.clouddirectory.model.BatchListPolicyAttachments
    ] = Optional.Absent,
    lookupPolicy: Optional[zio.aws.clouddirectory.model.BatchLookupPolicy] =
      Optional.Absent,
    listIndex: Optional[zio.aws.clouddirectory.model.BatchListIndex] =
      Optional.Absent,
    listOutgoingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks
    ] = Optional.Absent,
    listIncomingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks
    ] = Optional.Absent,
    getLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetLinkAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation = {
    import BatchReadOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
      .builder()
      .optionallyWith(listObjectAttributes.map(value => value.buildAwsValue()))(
        _.listObjectAttributes
      )
      .optionallyWith(listObjectChildren.map(value => value.buildAwsValue()))(
        _.listObjectChildren
      )
      .optionallyWith(listAttachedIndices.map(value => value.buildAwsValue()))(
        _.listAttachedIndices
      )
      .optionallyWith(
        listObjectParentPaths.map(value => value.buildAwsValue())
      )(_.listObjectParentPaths)
      .optionallyWith(getObjectInformation.map(value => value.buildAwsValue()))(
        _.getObjectInformation
      )
      .optionallyWith(getObjectAttributes.map(value => value.buildAwsValue()))(
        _.getObjectAttributes
      )
      .optionallyWith(listObjectParents.map(value => value.buildAwsValue()))(
        _.listObjectParents
      )
      .optionallyWith(listObjectPolicies.map(value => value.buildAwsValue()))(
        _.listObjectPolicies
      )
      .optionallyWith(
        listPolicyAttachments.map(value => value.buildAwsValue())
      )(_.listPolicyAttachments)
      .optionallyWith(lookupPolicy.map(value => value.buildAwsValue()))(
        _.lookupPolicy
      )
      .optionallyWith(listIndex.map(value => value.buildAwsValue()))(
        _.listIndex
      )
      .optionallyWith(
        listOutgoingTypedLinks.map(value => value.buildAwsValue())
      )(_.listOutgoingTypedLinks)
      .optionallyWith(
        listIncomingTypedLinks.map(value => value.buildAwsValue())
      )(_.listIncomingTypedLinks)
      .optionallyWith(getLinkAttributes.map(value => value.buildAwsValue()))(
        _.getLinkAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadOperation.wrap(buildAwsValue())
}
object BatchReadOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadOperation =
      zio.aws.clouddirectory.model.BatchReadOperation(
        listObjectAttributes.map(value => value.asEditable),
        listObjectChildren.map(value => value.asEditable),
        listAttachedIndices.map(value => value.asEditable),
        listObjectParentPaths.map(value => value.asEditable),
        getObjectInformation.map(value => value.asEditable),
        getObjectAttributes.map(value => value.asEditable),
        listObjectParents.map(value => value.asEditable),
        listObjectPolicies.map(value => value.asEditable),
        listPolicyAttachments.map(value => value.asEditable),
        lookupPolicy.map(value => value.asEditable),
        listIndex.map(value => value.asEditable),
        listOutgoingTypedLinks.map(value => value.asEditable),
        listIncomingTypedLinks.map(value => value.asEditable),
        getLinkAttributes.map(value => value.asEditable)
      )
    def listObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly
    ]
    def listObjectChildren: Optional[
      zio.aws.clouddirectory.model.BatchListObjectChildren.ReadOnly
    ]
    def listAttachedIndices: Optional[
      zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly
    ]
    def listObjectParentPaths: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentPaths.ReadOnly
    ]
    def getObjectInformation: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly
    ]
    def getObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly
    ]
    def listObjectParents
        : Optional[zio.aws.clouddirectory.model.BatchListObjectParents.ReadOnly]
    def listObjectPolicies: Optional[
      zio.aws.clouddirectory.model.BatchListObjectPolicies.ReadOnly
    ]
    def listPolicyAttachments: Optional[
      zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly
    ]
    def lookupPolicy
        : Optional[zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly]
    def listIndex
        : Optional[zio.aws.clouddirectory.model.BatchListIndex.ReadOnly]
    def listOutgoingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly
    ]
    def listIncomingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.ReadOnly
    ]
    def getLinkAttributes
        : Optional[zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly]
    def getListObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectAttributes", listObjectAttributes)
    def getListObjectChildren: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectChildren.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectChildren", listObjectChildren)
    def getListAttachedIndices: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly
    ] = AwsError.unwrapOptionField("listAttachedIndices", listAttachedIndices)
    def getListObjectParentPaths: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParentPaths.ReadOnly
    ] =
      AwsError.unwrapOptionField("listObjectParentPaths", listObjectParentPaths)
    def getGetObjectInformation: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectInformation", getObjectInformation)
    def getGetObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectAttributes", getObjectAttributes)
    def getListObjectParents: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParents.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectParents", listObjectParents)
    def getListObjectPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectPolicies", listObjectPolicies)
    def getListPolicyAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly
    ] =
      AwsError.unwrapOptionField("listPolicyAttachments", listPolicyAttachments)
    def getLookupPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("lookupPolicy", lookupPolicy)
    def getListIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIndex.ReadOnly
    ] = AwsError.unwrapOptionField("listIndex", listIndex)
    def getListOutgoingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listOutgoingTypedLinks",
      listOutgoingTypedLinks
    )
    def getListIncomingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listIncomingTypedLinks",
      listIncomingTypedLinks
    )
    def getGetLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("getLinkAttributes", getLinkAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
  ) extends zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly {
    override val listObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectAttributes.wrap(value)
      )
    override val listObjectChildren: Optional[
      zio.aws.clouddirectory.model.BatchListObjectChildren.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectChildren())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectChildren.wrap(value)
      )
    override val listAttachedIndices: Optional[
      zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listAttachedIndices())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListAttachedIndices.wrap(value)
      )
    override val listObjectParentPaths: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentPaths.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectParentPaths())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParentPaths.wrap(value)
      )
    override val getObjectInformation: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getObjectInformation())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectInformation.wrap(value)
      )
    override val getObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectAttributes.wrap(value)
      )
    override val listObjectParents: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParents.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectParents())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParents.wrap(value)
      )
    override val listObjectPolicies: Optional[
      zio.aws.clouddirectory.model.BatchListObjectPolicies.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectPolicies())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectPolicies.wrap(value)
      )
    override val listPolicyAttachments: Optional[
      zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listPolicyAttachments())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListPolicyAttachments.wrap(value)
      )
    override val lookupPolicy
        : Optional[zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookupPolicy())
        .map(value =>
          zio.aws.clouddirectory.model.BatchLookupPolicy.wrap(value)
        )
    override val listIndex
        : Optional[zio.aws.clouddirectory.model.BatchListIndex.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listIndex())
        .map(value => zio.aws.clouddirectory.model.BatchListIndex.wrap(value))
    override val listOutgoingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listOutgoingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.wrap(value)
      )
    override val listIncomingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listIncomingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.wrap(value)
      )
    override val getLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetLinkAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
  ): zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly = new Wrapper(
    impl
  )
}
