package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{SchemaName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSchemaRequest(schemaArn: Arn, name: SchemaName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest = {
    import UpdateSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(SchemaName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.UpdateSchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpdateSchemaRequest.wrap(buildAwsValue())
}
object UpdateSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpdateSchemaRequest =
      zio.aws.clouddirectory.model.UpdateSchemaRequest(schemaArn, name)
    def schemaArn: Arn
    def name: SchemaName
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, SchemaName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest
  ) extends zio.aws.clouddirectory.model.UpdateSchemaRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: SchemaName =
      zio.aws.clouddirectory.model.primitives.SchemaName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest
  ): zio.aws.clouddirectory.model.UpdateSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
