package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  RuleParameterValue,
  RuleParameterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Rule(
    `type`: Optional[zio.aws.clouddirectory.model.RuleType] = Optional.Absent,
    parameters: Optional[Map[RuleParameterKey, RuleParameterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.Rule
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (RuleParameterKey
                .unwrap(key): java.lang.String) -> (RuleParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.Rule.ReadOnly =
    zio.aws.clouddirectory.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.Rule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.Rule =
      zio.aws.clouddirectory.model
        .Rule(`type`.map(value => value), parameters.map(value => value))
    def `type`: Optional[zio.aws.clouddirectory.model.RuleType]
    def parameters: Optional[Map[RuleParameterKey, RuleParameterValue]]
    def getType: ZIO[Any, AwsError, zio.aws.clouddirectory.model.RuleType] =
      AwsError.unwrapOptionField("type", `type`)
    def getParameters
        : ZIO[Any, AwsError, Map[RuleParameterKey, RuleParameterValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.Rule
  ) extends zio.aws.clouddirectory.model.Rule.ReadOnly {
    override val `type`: Optional[zio.aws.clouddirectory.model.RuleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.clouddirectory.model.RuleType.wrap(value))
    override val parameters
        : Optional[Map[RuleParameterKey, RuleParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.clouddirectory.model.primitives.RuleParameterKey(
                key
              ) -> zio.aws.clouddirectory.model.primitives
                .RuleParameterValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.Rule
  ): zio.aws.clouddirectory.model.Rule.ReadOnly = new Wrapper(impl)
}
