package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnableDirectoryRequest(directoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest = {
    import EnableDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.EnableDirectoryRequest.ReadOnly =
    zio.aws.clouddirectory.model.EnableDirectoryRequest.wrap(buildAwsValue())
}
object EnableDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.EnableDirectoryRequest =
      zio.aws.clouddirectory.model.EnableDirectoryRequest(directoryArn)
    def directoryArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest
  ) extends zio.aws.clouddirectory.model.EnableDirectoryRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest
  ): zio.aws.clouddirectory.model.EnableDirectoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
