package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{BatchReferenceName, LinkName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchDetachObject(
    parentReference: zio.aws.clouddirectory.model.ObjectReference,
    linkName: LinkName,
    batchReferenceName: Optional[BatchReferenceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject = {
    import BatchDetachObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject
      .builder()
      .parentReference(parentReference.buildAwsValue())
      .linkName(LinkName.unwrap(linkName): java.lang.String)
      .optionallyWith(
        batchReferenceName.map(value =>
          BatchReferenceName.unwrap(value): java.lang.String
        )
      )(_.batchReferenceName)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly =
    zio.aws.clouddirectory.model.BatchDetachObject.wrap(buildAwsValue())
}
object BatchDetachObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDetachObject =
      zio.aws.clouddirectory.model.BatchDetachObject(
        parentReference.asEditable,
        linkName,
        batchReferenceName.map(value => value)
      )
    def parentReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def linkName: LinkName
    def batchReferenceName: Optional[BatchReferenceName]
    def getParentReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(parentReference)
    def getLinkName: ZIO[Any, Nothing, LinkName] = ZIO.succeed(linkName)
    def getBatchReferenceName: ZIO[Any, AwsError, BatchReferenceName] =
      AwsError.unwrapOptionField("batchReferenceName", batchReferenceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject
  ) extends zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly {
    override val parentReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.parentReference())
    override val linkName: LinkName =
      zio.aws.clouddirectory.model.primitives.LinkName(impl.linkName())
    override val batchReferenceName: Optional[BatchReferenceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchReferenceName())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.BatchReferenceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject
  ): zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly = new Wrapper(impl)
}
