package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{FacetName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFacetRequest(
    schemaArn: Arn,
    name: FacetName,
    attributeUpdates: Optional[
      Iterable[zio.aws.clouddirectory.model.FacetAttributeUpdate]
    ] = Optional.Absent,
    objectType: Optional[zio.aws.clouddirectory.model.ObjectType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest = {
    import UpdateFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(FacetName.unwrap(name): java.lang.String)
      .optionallyWith(
        attributeUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeUpdates)
      .optionallyWith(objectType.map(value => value.unwrap))(_.objectType)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.UpdateFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpdateFacetRequest.wrap(buildAwsValue())
}
object UpdateFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpdateFacetRequest =
      zio.aws.clouddirectory.model.UpdateFacetRequest(
        schemaArn,
        name,
        attributeUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectType.map(value => value)
      )
    def schemaArn: Arn
    def name: FacetName
    def attributeUpdates: Optional[
      List[zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly]
    ]
    def objectType: Optional[zio.aws.clouddirectory.model.ObjectType]
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, FacetName] = ZIO.succeed(name)
    def getAttributeUpdates: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeUpdates", attributeUpdates)
    def getObjectType
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ObjectType] =
      AwsError.unwrapOptionField("objectType", objectType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest
  ) extends zio.aws.clouddirectory.model.UpdateFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.name())
    override val attributeUpdates: Optional[
      List[zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.FacetAttributeUpdate.wrap(item)
        }.toList
      )
    override val objectType: Optional[zio.aws.clouddirectory.model.ObjectType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectType())
        .map(value => zio.aws.clouddirectory.model.ObjectType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest
  ): zio.aws.clouddirectory.model.UpdateFacetRequest.ReadOnly = new Wrapper(
    impl
  )
}
