package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{AttributeName, TypedLinkName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TypedLinkFacet(
    name: TypedLinkName,
    attributes: Iterable[
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition
    ],
    identityAttributeOrder: Iterable[AttributeName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet = {
    import TypedLinkFacet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet
      .builder()
      .name(TypedLinkName.unwrap(name): java.lang.String)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .identityAttributeOrder(identityAttributeOrder.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.TypedLinkFacet.ReadOnly =
    zio.aws.clouddirectory.model.TypedLinkFacet.wrap(buildAwsValue())
}
object TypedLinkFacet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedLinkFacet =
      zio.aws.clouddirectory.model.TypedLinkFacet(
        name,
        attributes.map { item =>
          item.asEditable
        },
        identityAttributeOrder
      )
    def name: TypedLinkName
    def attributes: List[
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    ]
    def identityAttributeOrder: List[AttributeName]
    def getName: ZIO[Any, Nothing, TypedLinkName] = ZIO.succeed(name)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    ]] = ZIO.succeed(attributes)
    def getIdentityAttributeOrder: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(identityAttributeOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet
  ) extends zio.aws.clouddirectory.model.TypedLinkFacet.ReadOnly {
    override val name: TypedLinkName =
      zio.aws.clouddirectory.model.primitives.TypedLinkName(impl.name())
    override val attributes: List[
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    ] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.wrap(item)
      }
      .toList
    override val identityAttributeOrder: List[AttributeName] = impl
      .identityAttributeOrder()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.primitives.AttributeName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet
  ): zio.aws.clouddirectory.model.TypedLinkFacet.ReadOnly = new Wrapper(impl)
}
