package zio.aws.clouddirectory.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{
  StringAttributeValue,
  NumberAttributeValue,
  DatetimeAttributeValue,
  BooleanAttributeValue,
  BinaryAttributeValue
}
import scala.jdk.CollectionConverters.*
final case class TypedAttributeValue(
    stringValue: Optional[StringAttributeValue] = Optional.Absent,
    binaryValue: Optional[BinaryAttributeValue] = Optional.Absent,
    booleanValue: Optional[BooleanAttributeValue] = Optional.Absent,
    numberValue: Optional[NumberAttributeValue] = Optional.Absent,
    datetimeValue: Optional[DatetimeAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue = {
    import TypedAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          StringAttributeValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        binaryValue.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.binaryValue)
      .optionallyWith(
        booleanValue.map(value =>
          BooleanAttributeValue.unwrap(value): java.lang.Boolean
        )
      )(_.booleanValue)
      .optionallyWith(
        numberValue.map(value =>
          NumberAttributeValue.unwrap(value): java.lang.String
        )
      )(_.numberValue)
      .optionallyWith(
        datetimeValue.map(value =>
          DatetimeAttributeValue.unwrap(value): Instant
        )
      )(_.datetimeValue)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly =
    zio.aws.clouddirectory.model.TypedAttributeValue.wrap(buildAwsValue())
}
object TypedAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedAttributeValue =
      zio.aws.clouddirectory.model.TypedAttributeValue(
        stringValue.map(value => value),
        binaryValue.map(value => value),
        booleanValue.map(value => value),
        numberValue.map(value => value),
        datetimeValue.map(value => value)
      )
    def stringValue: Optional[StringAttributeValue]
    def binaryValue: Optional[BinaryAttributeValue]
    def booleanValue: Optional[BooleanAttributeValue]
    def numberValue: Optional[NumberAttributeValue]
    def datetimeValue: Optional[DatetimeAttributeValue]
    def getStringValue: ZIO[Any, AwsError, StringAttributeValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getBinaryValue: ZIO[Any, AwsError, BinaryAttributeValue] =
      AwsError.unwrapOptionField("binaryValue", binaryValue)
    def getBooleanValue: ZIO[Any, AwsError, BooleanAttributeValue] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getNumberValue: ZIO[Any, AwsError, NumberAttributeValue] =
      AwsError.unwrapOptionField("numberValue", numberValue)
    def getDatetimeValue: ZIO[Any, AwsError, DatetimeAttributeValue] =
      AwsError.unwrapOptionField("datetimeValue", datetimeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
  ) extends zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly {
    override val stringValue: Optional[StringAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.StringAttributeValue(value)
        )
    override val binaryValue: Optional[BinaryAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binaryValue())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.BinaryAttributeValue(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
    override val booleanValue: Optional[BooleanAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.booleanValue())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.BooleanAttributeValue(value)
        )
    override val numberValue: Optional[NumberAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberValue())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.NumberAttributeValue(value)
        )
    override val datetimeValue: Optional[DatetimeAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datetimeValue())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.DatetimeAttributeValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
  ): zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly = new Wrapper(
    impl
  )
}
