package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{SchemaJsonDocument, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutSchemaFromJsonRequest(
    schemaArn: Arn,
    document: SchemaJsonDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest = {
    import PutSchemaFromJsonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .document(SchemaJsonDocument.unwrap(document): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.PutSchemaFromJsonRequest.ReadOnly =
    zio.aws.clouddirectory.model.PutSchemaFromJsonRequest.wrap(buildAwsValue())
}
object PutSchemaFromJsonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PutSchemaFromJsonRequest =
      zio.aws.clouddirectory.model.PutSchemaFromJsonRequest(schemaArn, document)
    def schemaArn: Arn
    def document: SchemaJsonDocument
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getDocument: ZIO[Any, Nothing, SchemaJsonDocument] =
      ZIO.succeed(document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest
  ) extends zio.aws.clouddirectory.model.PutSchemaFromJsonRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val document: SchemaJsonDocument =
      zio.aws.clouddirectory.model.primitives
        .SchemaJsonDocument(impl.document())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest
  ): zio.aws.clouddirectory.model.PutSchemaFromJsonRequest.ReadOnly =
    new Wrapper(impl)
}
