package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectType {
  def unwrap: software.amazon.awssdk.services.clouddirectory.model.ObjectType
}
object ObjectType {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.ObjectType
  ): zio.aws.clouddirectory.model.ObjectType = value match {
    case software.amazon.awssdk.services.clouddirectory.model.ObjectType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.ObjectType.NODE =>
      val r = NODE
      r
    case software.amazon.awssdk.services.clouddirectory.model.ObjectType.LEAF_NODE =>
      val r = LEAF_NODE
      r
    case software.amazon.awssdk.services.clouddirectory.model.ObjectType.POLICY =>
      val r = POLICY
      r
    case software.amazon.awssdk.services.clouddirectory.model.ObjectType.INDEX =>
      val r = INDEX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.ObjectType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ObjectType =
      software.amazon.awssdk.services.clouddirectory.model.ObjectType.UNKNOWN_TO_SDK_VERSION
  }
  case object NODE extends zio.aws.clouddirectory.model.ObjectType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ObjectType =
      software.amazon.awssdk.services.clouddirectory.model.ObjectType.NODE
  }
  case object LEAF_NODE extends zio.aws.clouddirectory.model.ObjectType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ObjectType =
      software.amazon.awssdk.services.clouddirectory.model.ObjectType.LEAF_NODE
  }
  case object POLICY extends zio.aws.clouddirectory.model.ObjectType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ObjectType =
      software.amazon.awssdk.services.clouddirectory.model.ObjectType.POLICY
  }
  case object INDEX extends zio.aws.clouddirectory.model.ObjectType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ObjectType =
      software.amazon.awssdk.services.clouddirectory.model.ObjectType.INDEX
  }
}
