package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListObjectAttributesRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent,
    consistencyLevel: Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      Optional.Absent,
    facetFilter: Optional[zio.aws.clouddirectory.model.SchemaFacet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest = {
    import ListObjectAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .optionallyWith(facetFilter.map(value => value.buildAwsValue()))(
        _.facetFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectAttributesRequest
      .wrap(buildAwsValue())
}
object ListObjectAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectAttributesRequest =
      zio.aws.clouddirectory.model.ListObjectAttributesRequest(
        directoryArn,
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value),
        consistencyLevel.map(value => value),
        facetFilter.map(value => value.asEditable)
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel]
    def facetFilter: Optional[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
    def getFacetFilter: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    ] = AwsError.unwrapOptionField("facetFilter", facetFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest
  ) extends zio.aws.clouddirectory.model.ListObjectAttributesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistencyLevel())
        .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
    override val facetFilter
        : Optional[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facetFilter())
        .map(value => zio.aws.clouddirectory.model.SchemaFacet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest
  ): zio.aws.clouddirectory.model.ListObjectAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
