package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDirectoriesResponse(
    directories: Iterable[zio.aws.clouddirectory.model.Directory],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse = {
    import ListDirectoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse
      .builder()
      .directories(directories.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListDirectoriesResponse.wrap(buildAwsValue())
}
object ListDirectoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListDirectoriesResponse =
      zio.aws.clouddirectory.model.ListDirectoriesResponse(
        directories.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def directories: List[zio.aws.clouddirectory.model.Directory.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDirectories: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.Directory.ReadOnly
    ]] = ZIO.succeed(directories)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse
  ) extends zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly {
    override val directories
        : List[zio.aws.clouddirectory.model.Directory.ReadOnly] = impl
      .directories()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.Directory.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse
  ): zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly =
    new Wrapper(impl)
}
