package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetObjectAttributesResponse(
    attributes: Optional[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse = {
    import GetObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetObjectAttributesResponse
      .wrap(buildAwsValue())
}
object GetObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetObjectAttributesResponse =
      zio.aws.clouddirectory.model.GetObjectAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes: Optional[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse
  ) extends zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly {
    override val attributes: Optional[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse
  ): zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
