package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{AttributeName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetObjectAttributesRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    consistencyLevel: Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      Optional.Absent,
    schemaFacet: zio.aws.clouddirectory.model.SchemaFacet,
    attributeNames: Iterable[AttributeName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest = {
    import GetObjectAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .schemaFacet(schemaFacet.buildAwsValue())
      .attributeNames(attributeNames.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetObjectAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetObjectAttributesRequest
      .wrap(buildAwsValue())
}
object GetObjectAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetObjectAttributesRequest =
      zio.aws.clouddirectory.model.GetObjectAttributesRequest(
        directoryArn,
        objectReference.asEditable,
        consistencyLevel.map(value => value),
        schemaFacet.asEditable,
        attributeNames
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel]
    def schemaFacet: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    def attributeNames: List[AttributeName]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
    def getSchemaFacet
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      ZIO.succeed(schemaFacet)
    def getAttributeNames: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest
  ) extends zio.aws.clouddirectory.model.GetObjectAttributesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistencyLevel())
        .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
    override val schemaFacet
        : zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
      zio.aws.clouddirectory.model.SchemaFacet.wrap(impl.schemaFacet())
    override val attributeNames: List[AttributeName] = impl
      .attributeNames()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.primitives.AttributeName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest
  ): zio.aws.clouddirectory.model.GetObjectAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
