package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{AttributeName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLinkAttributesRequest(
    directoryArn: Arn,
    typedLinkSpecifier: zio.aws.clouddirectory.model.TypedLinkSpecifier,
    attributeNames: Iterable[AttributeName],
    consistencyLevel: Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest = {
    import GetLinkAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .typedLinkSpecifier(typedLinkSpecifier.buildAwsValue())
      .attributeNames(attributeNames.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetLinkAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetLinkAttributesRequest.wrap(buildAwsValue())
}
object GetLinkAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetLinkAttributesRequest =
      zio.aws.clouddirectory.model.GetLinkAttributesRequest(
        directoryArn,
        typedLinkSpecifier.asEditable,
        attributeNames,
        consistencyLevel.map(value => value)
      )
    def directoryArn: Arn
    def typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    def attributeNames: List[AttributeName]
    def consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getTypedLinkSpecifier: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = ZIO.succeed(typedLinkSpecifier)
    def getAttributeNames: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(attributeNames)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest
  ) extends zio.aws.clouddirectory.model.GetLinkAttributesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSpecifier
        .wrap(impl.typedLinkSpecifier())
    override val attributeNames: List[AttributeName] = impl
      .attributeNames()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.primitives.AttributeName(item)
      }
      .toList
    override val consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistencyLevel())
        .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest
  ): zio.aws.clouddirectory.model.GetLinkAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
