package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{RuleKey, Bool}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FacetAttributeDefinition(
    `type`: zio.aws.clouddirectory.model.FacetAttributeType,
    defaultValue: Optional[zio.aws.clouddirectory.model.TypedAttributeValue] =
      Optional.Absent,
    isImmutable: Optional[Bool] = Optional.Absent,
    rules: Optional[Map[RuleKey, zio.aws.clouddirectory.model.Rule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition = {
    import FacetAttributeDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(isImmutable.map(value => value: java.lang.Boolean))(
        _.isImmutable
      )
      .optionallyWith(
        rules.map(value =>
          value
            .map({ case (key, value) =>
              (RuleKey.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.FacetAttributeDefinition.ReadOnly =
    zio.aws.clouddirectory.model.FacetAttributeDefinition.wrap(buildAwsValue())
}
object FacetAttributeDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.FacetAttributeDefinition =
      zio.aws.clouddirectory.model.FacetAttributeDefinition(
        `type`,
        defaultValue.map(value => value.asEditable),
        isImmutable.map(value => value),
        rules.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def `type`: zio.aws.clouddirectory.model.FacetAttributeType
    def defaultValue
        : Optional[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly]
    def isImmutable: Optional[Bool]
    def rules
        : Optional[Map[RuleKey, zio.aws.clouddirectory.model.Rule.ReadOnly]]
    def getType
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.FacetAttributeType] =
      ZIO.succeed(`type`)
    def getDefaultValue: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getIsImmutable: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isImmutable", isImmutable)
    def getRules: ZIO[Any, AwsError, Map[
      RuleKey,
      zio.aws.clouddirectory.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition
  ) extends zio.aws.clouddirectory.model.FacetAttributeDefinition.ReadOnly {
    override val `type`: zio.aws.clouddirectory.model.FacetAttributeType =
      zio.aws.clouddirectory.model.FacetAttributeType.wrap(impl.`type`())
    override val defaultValue
        : Optional[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value =>
          zio.aws.clouddirectory.model.TypedAttributeValue.wrap(value)
        )
    override val isImmutable: Optional[Bool] = zio.aws.core.internal
      .optionalFromNullable(impl.isImmutable())
      .map(value => value: Bool)
    override val rules
        : Optional[Map[RuleKey, zio.aws.clouddirectory.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.clouddirectory.model.primitives
                .RuleKey(key) -> zio.aws.clouddirectory.model.Rule.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition
  ): zio.aws.clouddirectory.model.FacetAttributeDefinition.ReadOnly =
    new Wrapper(impl)
}
