package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{Arn, DirectoryName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDirectoryRequest(name: DirectoryName, schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest = {
    import CreateDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest
      .builder()
      .name(DirectoryName.unwrap(name): java.lang.String)
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateDirectoryRequest.ReadOnly =
    zio.aws.clouddirectory.model.CreateDirectoryRequest.wrap(buildAwsValue())
}
object CreateDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateDirectoryRequest =
      zio.aws.clouddirectory.model.CreateDirectoryRequest(name, schemaArn)
    def name: DirectoryName
    def schemaArn: Arn
    def getName: ZIO[Any, Nothing, DirectoryName] = ZIO.succeed(name)
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest
  ) extends zio.aws.clouddirectory.model.CreateDirectoryRequest.ReadOnly {
    override val name: DirectoryName =
      zio.aws.clouddirectory.model.primitives.DirectoryName(impl.name())
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest
  ): zio.aws.clouddirectory.model.CreateDirectoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
