package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetObjectInformationResponse(
    schemaFacets: Optional[Iterable[zio.aws.clouddirectory.model.SchemaFacet]] =
      Optional.Absent,
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse = {
    import BatchGetObjectInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse
      .builder()
      .optionallyWith(
        schemaFacets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaFacets)
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchGetObjectInformationResponse
      .wrap(buildAwsValue())
}
object BatchGetObjectInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchGetObjectInformationResponse =
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse(
        schemaFacets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectIdentifier.map(value => value)
      )
    def schemaFacets
        : Optional[List[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly]]
    def objectIdentifier: Optional[ObjectIdentifier]
    def getSchemaFacets: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaFacets", schemaFacets)
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse
  ) extends zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly {
    override val schemaFacets
        : Optional[List[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaFacets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.SchemaFacet.wrap(item)
          }.toList
        )
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse
  ): zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly =
    new Wrapper(impl)
}
