package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDetachPolicy(
    policyReference: zio.aws.clouddirectory.model.ObjectReference,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicy = {
    import BatchDetachPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicy
      .builder()
      .policyReference(policyReference.buildAwsValue())
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly =
    zio.aws.clouddirectory.model.BatchDetachPolicy.wrap(buildAwsValue())
}
object BatchDetachPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDetachPolicy =
      zio.aws.clouddirectory.model.BatchDetachPolicy(
        policyReference.asEditable,
        objectReference.asEditable
      )
    def policyReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(policyReference)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicy
  ) extends zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly {
    override val policyReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.policyReference())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicy
  ): zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly = new Wrapper(impl)
}
