package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchAttachToIndexResponse(
    attachedObjectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse = {
    import BatchAttachToIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse
      .builder()
      .optionallyWith(
        attachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.attachedObjectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchAttachToIndexResponse
      .wrap(buildAwsValue())
}
object BatchAttachToIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAttachToIndexResponse =
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse(
        attachedObjectIdentifier.map(value => value)
      )
    def attachedObjectIdentifier: Optional[ObjectIdentifier]
    def getAttachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "attachedObjectIdentifier",
        attachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse
  ) extends zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly {
    override val attachedObjectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedObjectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse
  ): zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly =
    new Wrapper(impl)
}
