package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchAttachToIndex(
    indexReference: zio.aws.clouddirectory.model.ObjectReference,
    targetReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndex = {
    import BatchAttachToIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndex
      .builder()
      .indexReference(indexReference.buildAwsValue())
      .targetReference(targetReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly =
    zio.aws.clouddirectory.model.BatchAttachToIndex.wrap(buildAwsValue())
}
object BatchAttachToIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAttachToIndex =
      zio.aws.clouddirectory.model.BatchAttachToIndex(
        indexReference.asEditable,
        targetReference.asEditable
      )
    def indexReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def targetReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getIndexReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(indexReference)
    def getTargetReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndex
  ) extends zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly {
    override val indexReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.indexReference())
    override val targetReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.targetReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndex
  ): zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly = new Wrapper(
    impl
  )
}
