package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AttachToIndexResponse(
    attachedObjectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse = {
    import AttachToIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse
      .builder()
      .optionallyWith(
        attachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.attachedObjectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.AttachToIndexResponse.wrap(buildAwsValue())
}
object AttachToIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachToIndexResponse =
      zio.aws.clouddirectory.model
        .AttachToIndexResponse(attachedObjectIdentifier.map(value => value))
    def attachedObjectIdentifier: Optional[ObjectIdentifier]
    def getAttachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "attachedObjectIdentifier",
        attachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse
  ) extends zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly {
    override val attachedObjectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedObjectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse
  ): zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
