package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FacetAttributeUpdate(
    attribute: Optional[zio.aws.clouddirectory.model.FacetAttribute] =
      Optional.Absent,
    action: Optional[zio.aws.clouddirectory.model.UpdateActionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate = {
    import FacetAttributeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
      .builder()
      .optionallyWith(attribute.map(value => value.buildAwsValue()))(
        _.attribute
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly =
    zio.aws.clouddirectory.model.FacetAttributeUpdate.wrap(buildAwsValue())
}
object FacetAttributeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.FacetAttributeUpdate =
      zio.aws.clouddirectory.model.FacetAttributeUpdate(
        attribute.map(value => value.asEditable),
        action.map(value => value)
      )
    def attribute
        : Optional[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly]
    def action: Optional[zio.aws.clouddirectory.model.UpdateActionType]
    def getAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("attribute", attribute)
    def getAction
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.UpdateActionType] =
      AwsError.unwrapOptionField("action", action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
  ) extends zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly {
    override val attribute
        : Optional[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.clouddirectory.model.FacetAttribute.wrap(value))
    override val action
        : Optional[zio.aws.clouddirectory.model.UpdateActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.clouddirectory.model.UpdateActionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
  ): zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly = new Wrapper(
    impl
  )
}
