package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{LinkName, Bool, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateIndexRequest(
    directoryArn: Arn,
    orderedIndexedAttributeList: Iterable[
      zio.aws.clouddirectory.model.AttributeKey
    ],
    isUnique: Bool,
    parentReference: Optional[zio.aws.clouddirectory.model.ObjectReference] =
      Optional.Absent,
    linkName: Optional[LinkName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest = {
    import CreateIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .orderedIndexedAttributeList(orderedIndexedAttributeList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .isUnique(isUnique: java.lang.Boolean)
      .optionallyWith(parentReference.map(value => value.buildAwsValue()))(
        _.parentReference
      )
      .optionallyWith(
        linkName.map(value => LinkName.unwrap(value): java.lang.String)
      )(_.linkName)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateIndexRequest.ReadOnly =
    zio.aws.clouddirectory.model.CreateIndexRequest.wrap(buildAwsValue())
}
object CreateIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateIndexRequest =
      zio.aws.clouddirectory.model.CreateIndexRequest(
        directoryArn,
        orderedIndexedAttributeList.map { item =>
          item.asEditable
        },
        isUnique,
        parentReference.map(value => value.asEditable),
        linkName.map(value => value)
      )
    def directoryArn: Arn
    def orderedIndexedAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKey.ReadOnly]
    def isUnique: Bool
    def parentReference
        : Optional[zio.aws.clouddirectory.model.ObjectReference.ReadOnly]
    def linkName: Optional[LinkName]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getOrderedIndexedAttributeList: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ]] = ZIO.succeed(orderedIndexedAttributeList)
    def getIsUnique: ZIO[Any, Nothing, Bool] = ZIO.succeed(isUnique)
    def getParentReference: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = AwsError.unwrapOptionField("parentReference", parentReference)
    def getLinkName: ZIO[Any, AwsError, LinkName] =
      AwsError.unwrapOptionField("linkName", linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest
  ) extends zio.aws.clouddirectory.model.CreateIndexRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val orderedIndexedAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKey.ReadOnly] = impl
      .orderedIndexedAttributeList()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.AttributeKey.wrap(item)
      }
      .toList
    override val isUnique: Bool = impl.isUnique(): Bool
    override val parentReference
        : Optional[zio.aws.clouddirectory.model.ObjectReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentReference())
        .map(value => zio.aws.clouddirectory.model.ObjectReference.wrap(value))
    override val linkName: Optional[LinkName] = zio.aws.core.internal
      .optionalFromNullable(impl.linkName())
      .map(value => zio.aws.clouddirectory.model.primitives.LinkName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest
  ): zio.aws.clouddirectory.model.CreateIndexRequest.ReadOnly = new Wrapper(
    impl
  )
}
