package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchListObjectParentsResponse(
    parentLinks: Optional[
      Iterable[zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentsResponse = {
    import BatchListObjectParentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentsResponse
      .builder()
      .optionallyWith(
        parentLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parentLinks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListObjectParentsResponse
      .wrap(buildAwsValue())
}
object BatchListObjectParentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchListObjectParentsResponse =
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse(
        parentLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def parentLinks: Optional[List[
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getParentLinks: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]] = AwsError.unwrapOptionField("parentLinks", parentLinks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentsResponse
  ) extends zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly {
    override val parentLinks: Optional[List[
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parentLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentsResponse
  ): zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly =
    new Wrapper(impl)
}
