package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttributeKeyAndValue(
    key: zio.aws.clouddirectory.model.AttributeKey,
    value: zio.aws.clouddirectory.model.TypedAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue = {
    import AttributeKeyAndValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue
      .builder()
      .key(key.buildAwsValue())
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly =
    zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(buildAwsValue())
}
object AttributeKeyAndValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttributeKeyAndValue =
      zio.aws.clouddirectory.model
        .AttributeKeyAndValue(key.asEditable, value.asEditable)
    def key: zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    def value: zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    def getKey: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ] = ZIO.succeed(key)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue
  ) extends zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly {
    override val key: zio.aws.clouddirectory.model.AttributeKey.ReadOnly =
      zio.aws.clouddirectory.model.AttributeKey.wrap(impl.key())
    override val value
        : zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly =
      zio.aws.clouddirectory.model.TypedAttributeValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue
  ): zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly = new Wrapper(
    impl
  )
}
