package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{TypedLinkName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TypedLinkSchemaAndFacetName(
    schemaArn: Arn,
    typedLinkName: TypedLinkName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName = {
    import TypedLinkSchemaAndFacetName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .typedLinkName(TypedLinkName.unwrap(typedLinkName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly =
    zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName
      .wrap(buildAwsValue())
}
object TypedLinkSchemaAndFacetName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName =
      zio.aws.clouddirectory.model
        .TypedLinkSchemaAndFacetName(schemaArn, typedLinkName)
    def schemaArn: Arn
    def typedLinkName: TypedLinkName
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getTypedLinkName: ZIO[Any, Nothing, TypedLinkName] =
      ZIO.succeed(typedLinkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName
  ) extends zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val typedLinkName: TypedLinkName =
      zio.aws.clouddirectory.model.primitives
        .TypedLinkName(impl.typedLinkName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName
  ): zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly =
    new Wrapper(impl)
}
