package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachPolicyRequest(
    directoryArn: Arn,
    policyReference: zio.aws.clouddirectory.model.ObjectReference,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest = {
    import AttachPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .policyReference(policyReference.buildAwsValue())
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttachPolicyRequest.ReadOnly =
    zio.aws.clouddirectory.model.AttachPolicyRequest.wrap(buildAwsValue())
}
object AttachPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachPolicyRequest =
      zio.aws.clouddirectory.model.AttachPolicyRequest(
        directoryArn,
        policyReference.asEditable,
        objectReference.asEditable
      )
    def directoryArn: Arn
    def policyReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(policyReference)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest
  ) extends zio.aws.clouddirectory.model.AttachPolicyRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val policyReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.policyReference())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest
  ): zio.aws.clouddirectory.model.AttachPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
