package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TypedLinkFacetAttributeUpdate(
    attribute: zio.aws.clouddirectory.model.TypedLinkAttributeDefinition,
    action: zio.aws.clouddirectory.model.UpdateActionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate = {
    import TypedLinkFacetAttributeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate
      .builder()
      .attribute(attribute.buildAwsValue())
      .action(action.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.ReadOnly =
    zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate
      .wrap(buildAwsValue())
}
object TypedLinkFacetAttributeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate =
      zio.aws.clouddirectory.model
        .TypedLinkFacetAttributeUpdate(attribute.asEditable, action)
    def attribute
        : zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    def action: zio.aws.clouddirectory.model.UpdateActionType
    def getAttribute: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    ] = ZIO.succeed(attribute)
    def getAction
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.UpdateActionType] =
      ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate
  ) extends zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.ReadOnly {
    override val attribute
        : zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition
        .wrap(impl.attribute())
    override val action: zio.aws.clouddirectory.model.UpdateActionType =
      zio.aws.clouddirectory.model.UpdateActionType.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate
  ): zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.ReadOnly =
    new Wrapper(impl)
}
