package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{
  NumberResults,
  NextToken,
  FacetName,
  Arn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFacetAttributesRequest(
    schemaArn: Arn,
    name: FacetName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest = {
    import ListFacetAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(FacetName.unwrap(name): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListFacetAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListFacetAttributesRequest
      .wrap(buildAwsValue())
}
object ListFacetAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListFacetAttributesRequest =
      zio.aws.clouddirectory.model.ListFacetAttributesRequest(
        schemaArn,
        name,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def schemaArn: Arn
    def name: FacetName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, FacetName] = ZIO.succeed(name)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest
  ) extends zio.aws.clouddirectory.model.ListFacetAttributesRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.name())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest
  ): zio.aws.clouddirectory.model.ListFacetAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
