package zio.aws.clouddirectory.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{
  Date,
  DirectoryArn,
  DirectoryName
}
import scala.jdk.CollectionConverters.*
final case class Directory(
    name: Optional[DirectoryName] = Optional.Absent,
    directoryArn: Optional[DirectoryArn] = Optional.Absent,
    state: Optional[zio.aws.clouddirectory.model.DirectoryState] =
      Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.Directory = {
    import Directory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.Directory
      .builder()
      .optionallyWith(
        name.map(value => DirectoryName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        directoryArn.map(value => DirectoryArn.unwrap(value): java.lang.String)
      )(_.directoryArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.Directory.ReadOnly =
    zio.aws.clouddirectory.model.Directory.wrap(buildAwsValue())
}
object Directory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.Directory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.Directory =
      zio.aws.clouddirectory.model.Directory(
        name.map(value => value),
        directoryArn.map(value => value),
        state.map(value => value),
        creationDateTime.map(value => value)
      )
    def name: Optional[DirectoryName]
    def directoryArn: Optional[DirectoryArn]
    def state: Optional[zio.aws.clouddirectory.model.DirectoryState]
    def creationDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, DirectoryName] =
      AwsError.unwrapOptionField("name", name)
    def getDirectoryArn: ZIO[Any, AwsError, DirectoryArn] =
      AwsError.unwrapOptionField("directoryArn", directoryArn)
    def getState
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.DirectoryState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.Directory
  ) extends zio.aws.clouddirectory.model.Directory.ReadOnly {
    override val name: Optional[DirectoryName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.DirectoryName(value)
      )
    override val directoryArn: Optional[DirectoryArn] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryArn())
      .map(value => zio.aws.clouddirectory.model.primitives.DirectoryArn(value))
    override val state: Optional[zio.aws.clouddirectory.model.DirectoryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.clouddirectory.model.DirectoryState.wrap(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.clouddirectory.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.Directory
  ): zio.aws.clouddirectory.model.Directory.ReadOnly = new Wrapper(impl)
}
