package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchUpdateLinkAttributes(
    typedLinkSpecifier: zio.aws.clouddirectory.model.TypedLinkSpecifier,
    attributeUpdates: Iterable[zio.aws.clouddirectory.model.LinkAttributeUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributes = {
    import BatchUpdateLinkAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributes
      .builder()
      .typedLinkSpecifier(typedLinkSpecifier.buildAwsValue())
      .attributeUpdates(attributeUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly =
    zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.wrap(buildAwsValue())
}
object BatchUpdateLinkAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchUpdateLinkAttributes =
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes(
        typedLinkSpecifier.asEditable,
        attributeUpdates.map { item =>
          item.asEditable
        }
      )
    def typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    def attributeUpdates
        : List[zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly]
    def getTypedLinkSpecifier: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = ZIO.succeed(typedLinkSpecifier)
    def getAttributeUpdates: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly
    ]] = ZIO.succeed(attributeUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributes
  ) extends zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly {
    override val typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSpecifier
        .wrap(impl.typedLinkSpecifier())
    override val attributeUpdates
        : List[zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly] = impl
      .attributeUpdates()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.LinkAttributeUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributes
  ): zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly =
    new Wrapper(impl)
}
