package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{Bool, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpgradeAppliedSchemaRequest(
    publishedSchemaArn: Arn,
    directoryArn: Arn,
    dryRun: Optional[Bool] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest = {
    import UpgradeAppliedSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest
      .builder()
      .publishedSchemaArn(Arn.unwrap(publishedSchemaArn): java.lang.String)
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpgradeAppliedSchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpgradeAppliedSchemaRequest
      .wrap(buildAwsValue())
}
object UpgradeAppliedSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpgradeAppliedSchemaRequest =
      zio.aws.clouddirectory.model.UpgradeAppliedSchemaRequest(
        publishedSchemaArn,
        directoryArn,
        dryRun.map(value => value)
      )
    def publishedSchemaArn: Arn
    def directoryArn: Arn
    def dryRun: Optional[Bool]
    def getPublishedSchemaArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(publishedSchemaArn)
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getDryRun: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest
  ) extends zio.aws.clouddirectory.model.UpgradeAppliedSchemaRequest.ReadOnly {
    override val publishedSchemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.publishedSchemaArn())
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val dryRun: Optional[Bool] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Bool)
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest
  ): zio.aws.clouddirectory.model.UpgradeAppliedSchemaRequest.ReadOnly =
    new Wrapper(impl)
}
