package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  AttributeName,
  TypedLinkName,
  Arn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateTypedLinkFacetRequest(
    schemaArn: Arn,
    name: TypedLinkName,
    attributeUpdates: Iterable[
      zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate
    ],
    identityAttributeOrder: Iterable[AttributeName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest = {
    import UpdateTypedLinkFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(TypedLinkName.unwrap(name): java.lang.String)
      .attributeUpdates(attributeUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .identityAttributeOrder(identityAttributeOrder.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpdateTypedLinkFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpdateTypedLinkFacetRequest
      .wrap(buildAwsValue())
}
object UpdateTypedLinkFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpdateTypedLinkFacetRequest =
      zio.aws.clouddirectory.model.UpdateTypedLinkFacetRequest(
        schemaArn,
        name,
        attributeUpdates.map { item =>
          item.asEditable
        },
        identityAttributeOrder
      )
    def schemaArn: Arn
    def name: TypedLinkName
    def attributeUpdates: List[
      zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.ReadOnly
    ]
    def identityAttributeOrder: List[AttributeName]
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, TypedLinkName] = ZIO.succeed(name)
    def getAttributeUpdates: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.ReadOnly
    ]] = ZIO.succeed(attributeUpdates)
    def getIdentityAttributeOrder: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(identityAttributeOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest
  ) extends zio.aws.clouddirectory.model.UpdateTypedLinkFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: TypedLinkName =
      zio.aws.clouddirectory.model.primitives.TypedLinkName(impl.name())
    override val attributeUpdates: List[
      zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.ReadOnly
    ] = impl
      .attributeUpdates()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate.wrap(item)
      }
      .toList
    override val identityAttributeOrder: List[AttributeName] = impl
      .identityAttributeOrder()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.primitives.AttributeName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest
  ): zio.aws.clouddirectory.model.UpdateTypedLinkFacetRequest.ReadOnly =
    new Wrapper(impl)
}
