package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters.*
sealed trait RangeMode {
  def unwrap: software.amazon.awssdk.services.clouddirectory.model.RangeMode
}
object RangeMode {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.RangeMode
  ): zio.aws.clouddirectory.model.RangeMode = value match {
    case software.amazon.awssdk.services.clouddirectory.model.RangeMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.RangeMode.FIRST =>
      val r = FIRST
      r
    case software.amazon.awssdk.services.clouddirectory.model.RangeMode.LAST =>
      val r = LAST
      r
    case software.amazon.awssdk.services.clouddirectory.model.RangeMode.LAST_BEFORE_MISSING_VALUES =>
      val r = LAST_BEFORE_MISSING_VALUES
      r
    case software.amazon.awssdk.services.clouddirectory.model.RangeMode.INCLUSIVE =>
      val r = INCLUSIVE
      r
    case software.amazon.awssdk.services.clouddirectory.model.RangeMode.EXCLUSIVE =>
      val r = EXCLUSIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.RangeMode {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RangeMode =
      software.amazon.awssdk.services.clouddirectory.model.RangeMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FIRST extends zio.aws.clouddirectory.model.RangeMode {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RangeMode =
      software.amazon.awssdk.services.clouddirectory.model.RangeMode.FIRST
  }
  case object LAST extends zio.aws.clouddirectory.model.RangeMode {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RangeMode =
      software.amazon.awssdk.services.clouddirectory.model.RangeMode.LAST
  }
  case object LAST_BEFORE_MISSING_VALUES
      extends zio.aws.clouddirectory.model.RangeMode {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RangeMode =
      software.amazon.awssdk.services.clouddirectory.model.RangeMode.LAST_BEFORE_MISSING_VALUES
  }
  case object INCLUSIVE extends zio.aws.clouddirectory.model.RangeMode {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RangeMode =
      software.amazon.awssdk.services.clouddirectory.model.RangeMode.INCLUSIVE
  }
  case object EXCLUSIVE extends zio.aws.clouddirectory.model.RangeMode {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RangeMode =
      software.amazon.awssdk.services.clouddirectory.model.RangeMode.EXCLUSIVE
  }
}
