package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutSchemaFromJsonResponse(
    arn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse = {
    import PutSchemaFromJsonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly =
    zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.wrap(buildAwsValue())
}
object PutSchemaFromJsonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PutSchemaFromJsonResponse =
      zio.aws.clouddirectory.model
        .PutSchemaFromJsonResponse(arn.map(value => value))
    def arn: Optional[Arn]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse
  ) extends zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse
  ): zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly =
    new Wrapper(impl)
}
