package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ObjectAttributeAction(
    objectAttributeActionType: Optional[
      zio.aws.clouddirectory.model.UpdateActionType
    ] = Optional.Absent,
    objectAttributeUpdateValue: Optional[
      zio.aws.clouddirectory.model.TypedAttributeValue
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction = {
    import ObjectAttributeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction
      .builder()
      .optionallyWith(objectAttributeActionType.map(value => value.unwrap))(
        _.objectAttributeActionType
      )
      .optionallyWith(
        objectAttributeUpdateValue.map(value => value.buildAwsValue())
      )(_.objectAttributeUpdateValue)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ObjectAttributeAction.ReadOnly =
    zio.aws.clouddirectory.model.ObjectAttributeAction.wrap(buildAwsValue())
}
object ObjectAttributeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ObjectAttributeAction =
      zio.aws.clouddirectory.model.ObjectAttributeAction(
        objectAttributeActionType.map(value => value),
        objectAttributeUpdateValue.map(value => value.asEditable)
      )
    def objectAttributeActionType
        : Optional[zio.aws.clouddirectory.model.UpdateActionType]
    def objectAttributeUpdateValue
        : Optional[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly]
    def getObjectAttributeActionType
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.UpdateActionType] =
      AwsError.unwrapOptionField(
        "objectAttributeActionType",
        objectAttributeActionType
      )
    def getObjectAttributeUpdateValue: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectAttributeUpdateValue",
      objectAttributeUpdateValue
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction
  ) extends zio.aws.clouddirectory.model.ObjectAttributeAction.ReadOnly {
    override val objectAttributeActionType
        : Optional[zio.aws.clouddirectory.model.UpdateActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectAttributeActionType())
        .map(value => zio.aws.clouddirectory.model.UpdateActionType.wrap(value))
    override val objectAttributeUpdateValue
        : Optional[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectAttributeUpdateValue())
        .map(value =>
          zio.aws.clouddirectory.model.TypedAttributeValue.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction
  ): zio.aws.clouddirectory.model.ObjectAttributeAction.ReadOnly = new Wrapper(
    impl
  )
}
