package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOutgoingTypedLinksResponse(
    typedLinkSpecifiers: Optional[
      Iterable[zio.aws.clouddirectory.model.TypedLinkSpecifier]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse = {
    import ListOutgoingTypedLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse
      .builder()
      .optionallyWith(
        typedLinkSpecifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typedLinkSpecifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse
      .wrap(buildAwsValue())
}
object ListOutgoingTypedLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse =
      zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse(
        typedLinkSpecifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def typedLinkSpecifiers: Optional[
      List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getTypedLinkSpecifiers: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ]] = AwsError.unwrapOptionField("typedLinkSpecifiers", typedLinkSpecifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse
  ) extends zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly {
    override val typedLinkSpecifiers: Optional[
      List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.typedLinkSpecifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse
  ): zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly =
    new Wrapper(impl)
}
