package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListIncomingTypedLinksResponse(
    linkSpecifiers: Optional[
      Iterable[zio.aws.clouddirectory.model.TypedLinkSpecifier]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse = {
    import ListIncomingTypedLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse
      .builder()
      .optionallyWith(
        linkSpecifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.linkSpecifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse
      .wrap(buildAwsValue())
}
object ListIncomingTypedLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse =
      zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse(
        linkSpecifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def linkSpecifiers: Optional[
      List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getLinkSpecifiers: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ]] = AwsError.unwrapOptionField("linkSpecifiers", linkSpecifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse
  ) extends zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly {
    override val linkSpecifiers: Optional[
      List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.linkSpecifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse
  ): zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly =
    new Wrapper(impl)
}
