package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, FacetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFacetNamesResponse(
    facetNames: Optional[Iterable[FacetName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse = {
    import ListFacetNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse
      .builder()
      .optionallyWith(
        facetNames.map(value =>
          value.map { item =>
            FacetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.facetNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListFacetNamesResponse.wrap(buildAwsValue())
}
object ListFacetNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListFacetNamesResponse =
      zio.aws.clouddirectory.model.ListFacetNamesResponse(
        facetNames.map(value => value),
        nextToken.map(value => value)
      )
    def facetNames: Optional[List[FacetName]]
    def nextToken: Optional[NextToken]
    def getFacetNames: ZIO[Any, AwsError, List[FacetName]] =
      AwsError.unwrapOptionField("facetNames", facetNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse
  ) extends zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly {
    override val facetNames: Optional[List[FacetName]] = zio.aws.core.internal
      .optionalFromNullable(impl.facetNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.FacetName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse
  ): zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly = new Wrapper(
    impl
  )
}
