package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLinkAttributesResponse(
    attributes: Optional[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse = {
    import GetLinkAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetLinkAttributesResponse.wrap(buildAwsValue())
}
object GetLinkAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetLinkAttributesResponse =
      zio.aws.clouddirectory.model.GetLinkAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes: Optional[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse
  ) extends zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly {
    override val attributes: Optional[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse
  ): zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
