package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDirectoryResponse(
    directory: zio.aws.clouddirectory.model.Directory
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse = {
    import GetDirectoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse
      .builder()
      .directory(directory.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetDirectoryResponse.wrap(buildAwsValue())
}
object GetDirectoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetDirectoryResponse =
      zio.aws.clouddirectory.model.GetDirectoryResponse(directory.asEditable)
    def directory: zio.aws.clouddirectory.model.Directory.ReadOnly
    def getDirectory
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.Directory.ReadOnly] =
      ZIO.succeed(directory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse
  ) extends zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly {
    override val directory: zio.aws.clouddirectory.model.Directory.ReadOnly =
      zio.aws.clouddirectory.model.Directory.wrap(impl.directory())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse
  ): zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
