package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.DirectoryArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDirectoryRequest(directoryArn: DirectoryArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest = {
    import GetDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest
      .builder()
      .directoryArn(DirectoryArn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.GetDirectoryRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetDirectoryRequest.wrap(buildAwsValue())
}
object GetDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetDirectoryRequest =
      zio.aws.clouddirectory.model.GetDirectoryRequest(directoryArn)
    def directoryArn: DirectoryArn
    def getDirectoryArn: ZIO[Any, Nothing, DirectoryArn] =
      ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest
  ) extends zio.aws.clouddirectory.model.GetDirectoryRequest.ReadOnly {
    override val directoryArn: DirectoryArn =
      zio.aws.clouddirectory.model.primitives.DirectoryArn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest
  ): zio.aws.clouddirectory.model.GetDirectoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
