package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTypedLinkFacetRequest(
    schemaArn: Arn,
    facet: zio.aws.clouddirectory.model.TypedLinkFacet
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest = {
    import CreateTypedLinkFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .facet(facet.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.CreateTypedLinkFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.CreateTypedLinkFacetRequest
      .wrap(buildAwsValue())
}
object CreateTypedLinkFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateTypedLinkFacetRequest =
      zio.aws.clouddirectory.model
        .CreateTypedLinkFacetRequest(schemaArn, facet.asEditable)
    def schemaArn: Arn
    def facet: zio.aws.clouddirectory.model.TypedLinkFacet.ReadOnly
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getFacet: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkFacet.ReadOnly
    ] = ZIO.succeed(facet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest
  ) extends zio.aws.clouddirectory.model.CreateTypedLinkFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val facet: zio.aws.clouddirectory.model.TypedLinkFacet.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkFacet.wrap(impl.facet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest
  ): zio.aws.clouddirectory.model.CreateTypedLinkFacetRequest.ReadOnly =
    new Wrapper(impl)
}
