package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateObjectResponse(
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse = {
    import CreateObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse
      .builder()
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly =
    zio.aws.clouddirectory.model.CreateObjectResponse.wrap(buildAwsValue())
}
object CreateObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateObjectResponse =
      zio.aws.clouddirectory.model
        .CreateObjectResponse(objectIdentifier.map(value => value))
    def objectIdentifier: Optional[ObjectIdentifier]
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse
  ) extends zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly {
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse
  ): zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
