package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchWriteRequest(
    directoryArn: Arn,
    operations: Iterable[zio.aws.clouddirectory.model.BatchWriteOperation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest = {
    import BatchWriteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .operations(operations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchWriteRequest.ReadOnly =
    zio.aws.clouddirectory.model.BatchWriteRequest.wrap(buildAwsValue())
}
object BatchWriteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchWriteRequest =
      zio.aws.clouddirectory.model.BatchWriteRequest(
        directoryArn,
        operations.map { item =>
          item.asEditable
        }
      )
    def directoryArn: Arn
    def operations
        : List[zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getOperations: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly
    ]] = ZIO.succeed(operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest
  ) extends zio.aws.clouddirectory.model.BatchWriteRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val operations
        : List[zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.BatchWriteOperation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest
  ): zio.aws.clouddirectory.model.BatchWriteRequest.ReadOnly = new Wrapper(impl)
}
