package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchWriteOperationResponse(
    createObject: Optional[
      zio.aws.clouddirectory.model.BatchCreateObjectResponse
    ] = Optional.Absent,
    attachObject: Optional[
      zio.aws.clouddirectory.model.BatchAttachObjectResponse
    ] = Optional.Absent,
    detachObject: Optional[
      zio.aws.clouddirectory.model.BatchDetachObjectResponse
    ] = Optional.Absent,
    updateObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse
    ] = Optional.Absent,
    deleteObject: Optional[
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse
    ] = Optional.Absent,
    addFacetToObject: Optional[
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse
    ] = Optional.Absent,
    removeFacetFromObject: Optional[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse
    ] = Optional.Absent,
    attachPolicy: Optional[
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse
    ] = Optional.Absent,
    detachPolicy: Optional[
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse
    ] = Optional.Absent,
    createIndex: Optional[
      zio.aws.clouddirectory.model.BatchCreateIndexResponse
    ] = Optional.Absent,
    attachToIndex: Optional[
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse
    ] = Optional.Absent,
    detachFromIndex: Optional[
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse
    ] = Optional.Absent,
    attachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse
    ] = Optional.Absent,
    detachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse
    ] = Optional.Absent,
    updateLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse = {
    import BatchWriteOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
      .builder()
      .optionallyWith(createObject.map(value => value.buildAwsValue()))(
        _.createObject
      )
      .optionallyWith(attachObject.map(value => value.buildAwsValue()))(
        _.attachObject
      )
      .optionallyWith(detachObject.map(value => value.buildAwsValue()))(
        _.detachObject
      )
      .optionallyWith(
        updateObjectAttributes.map(value => value.buildAwsValue())
      )(_.updateObjectAttributes)
      .optionallyWith(deleteObject.map(value => value.buildAwsValue()))(
        _.deleteObject
      )
      .optionallyWith(addFacetToObject.map(value => value.buildAwsValue()))(
        _.addFacetToObject
      )
      .optionallyWith(
        removeFacetFromObject.map(value => value.buildAwsValue())
      )(_.removeFacetFromObject)
      .optionallyWith(attachPolicy.map(value => value.buildAwsValue()))(
        _.attachPolicy
      )
      .optionallyWith(detachPolicy.map(value => value.buildAwsValue()))(
        _.detachPolicy
      )
      .optionallyWith(createIndex.map(value => value.buildAwsValue()))(
        _.createIndex
      )
      .optionallyWith(attachToIndex.map(value => value.buildAwsValue()))(
        _.attachToIndex
      )
      .optionallyWith(detachFromIndex.map(value => value.buildAwsValue()))(
        _.detachFromIndex
      )
      .optionallyWith(attachTypedLink.map(value => value.buildAwsValue()))(
        _.attachTypedLink
      )
      .optionallyWith(detachTypedLink.map(value => value.buildAwsValue()))(
        _.detachTypedLink
      )
      .optionallyWith(updateLinkAttributes.map(value => value.buildAwsValue()))(
        _.updateLinkAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchWriteOperationResponse
      .wrap(buildAwsValue())
}
object BatchWriteOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchWriteOperationResponse =
      zio.aws.clouddirectory.model.BatchWriteOperationResponse(
        createObject.map(value => value.asEditable),
        attachObject.map(value => value.asEditable),
        detachObject.map(value => value.asEditable),
        updateObjectAttributes.map(value => value.asEditable),
        deleteObject.map(value => value.asEditable),
        addFacetToObject.map(value => value.asEditable),
        removeFacetFromObject.map(value => value.asEditable),
        attachPolicy.map(value => value.asEditable),
        detachPolicy.map(value => value.asEditable),
        createIndex.map(value => value.asEditable),
        attachToIndex.map(value => value.asEditable),
        detachFromIndex.map(value => value.asEditable),
        attachTypedLink.map(value => value.asEditable),
        detachTypedLink.map(value => value.asEditable),
        updateLinkAttributes.map(value => value.asEditable)
      )
    def createObject: Optional[
      zio.aws.clouddirectory.model.BatchCreateObjectResponse.ReadOnly
    ]
    def attachObject: Optional[
      zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly
    ]
    def detachObject: Optional[
      zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly
    ]
    def updateObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly
    ]
    def deleteObject: Optional[
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse.ReadOnly
    ]
    def addFacetToObject: Optional[
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.ReadOnly
    ]
    def removeFacetFromObject: Optional[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse.ReadOnly
    ]
    def attachPolicy: Optional[
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse.ReadOnly
    ]
    def detachPolicy: Optional[
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse.ReadOnly
    ]
    def createIndex: Optional[
      zio.aws.clouddirectory.model.BatchCreateIndexResponse.ReadOnly
    ]
    def attachToIndex: Optional[
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly
    ]
    def detachFromIndex: Optional[
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly
    ]
    def attachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly
    ]
    def detachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.ReadOnly
    ]
    def updateLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse.ReadOnly
    ]
    def getCreateObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("createObject", createObject)
    def getAttachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachObject", attachObject)
    def getDetachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachObject", detachObject)
    def getUpdateObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateObjectAttributes",
      updateObjectAttributes
    )
    def getDeleteObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("deleteObject", deleteObject)
    def getAddFacetToObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("addFacetToObject", addFacetToObject)
    def getRemoveFacetFromObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("removeFacetFromObject", removeFacetFromObject)
    def getAttachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachPolicy", attachPolicy)
    def getDetachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachPolicy", detachPolicy)
    def getCreateIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("createIndex", createIndex)
    def getAttachToIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachToIndex", attachToIndex)
    def getDetachFromIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachFromIndex", detachFromIndex)
    def getAttachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachTypedLink", attachTypedLink)
    def getDetachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachTypedLink", detachTypedLink)
    def getUpdateLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("updateLinkAttributes", updateLinkAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
  ) extends zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly {
    override val createObject: Optional[
      zio.aws.clouddirectory.model.BatchCreateObjectResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchCreateObjectResponse.wrap(value)
      )
    override val attachObject: Optional[
      zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachObjectResponse.wrap(value)
      )
    override val detachObject: Optional[
      zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detachObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachObjectResponse.wrap(value)
      )
    override val updateObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse
          .wrap(value)
      )
    override val deleteObject: Optional[
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDeleteObjectResponse.wrap(value)
      )
    override val addFacetToObject: Optional[
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.addFacetToObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.wrap(value)
      )
    override val removeFacetFromObject: Optional[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removeFacetFromObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse
          .wrap(value)
      )
    override val attachPolicy: Optional[
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachPolicy())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachPolicyResponse.wrap(value)
      )
    override val detachPolicy: Optional[
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detachPolicy())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachPolicyResponse.wrap(value)
      )
    override val createIndex: Optional[
      zio.aws.clouddirectory.model.BatchCreateIndexResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchCreateIndexResponse.wrap(value)
      )
    override val attachToIndex: Optional[
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachToIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachToIndexResponse.wrap(value)
      )
    override val detachFromIndex: Optional[
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detachFromIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.wrap(value)
      )
    override val attachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachTypedLink())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.wrap(value)
      )
    override val detachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detachTypedLink())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.wrap(value)
      )
    override val updateLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
  ): zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly =
    new Wrapper(impl)
}
