package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchReadSuccessfulResponse(
    listObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse
    ] = Optional.Absent,
    listObjectChildren: Optional[
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse
    ] = Optional.Absent,
    getObjectInformation: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse
    ] = Optional.Absent,
    getObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse
    ] = Optional.Absent,
    listAttachedIndices: Optional[
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse
    ] = Optional.Absent,
    listObjectParentPaths: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse
    ] = Optional.Absent,
    listObjectPolicies: Optional[
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse
    ] = Optional.Absent,
    listPolicyAttachments: Optional[
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse
    ] = Optional.Absent,
    lookupPolicy: Optional[
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse
    ] = Optional.Absent,
    listIndex: Optional[zio.aws.clouddirectory.model.BatchListIndexResponse] =
      Optional.Absent,
    listOutgoingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse
    ] = Optional.Absent,
    listIncomingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse
    ] = Optional.Absent,
    getLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse
    ] = Optional.Absent,
    listObjectParents: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse = {
    import BatchReadSuccessfulResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
      .builder()
      .optionallyWith(listObjectAttributes.map(value => value.buildAwsValue()))(
        _.listObjectAttributes
      )
      .optionallyWith(listObjectChildren.map(value => value.buildAwsValue()))(
        _.listObjectChildren
      )
      .optionallyWith(getObjectInformation.map(value => value.buildAwsValue()))(
        _.getObjectInformation
      )
      .optionallyWith(getObjectAttributes.map(value => value.buildAwsValue()))(
        _.getObjectAttributes
      )
      .optionallyWith(listAttachedIndices.map(value => value.buildAwsValue()))(
        _.listAttachedIndices
      )
      .optionallyWith(
        listObjectParentPaths.map(value => value.buildAwsValue())
      )(_.listObjectParentPaths)
      .optionallyWith(listObjectPolicies.map(value => value.buildAwsValue()))(
        _.listObjectPolicies
      )
      .optionallyWith(
        listPolicyAttachments.map(value => value.buildAwsValue())
      )(_.listPolicyAttachments)
      .optionallyWith(lookupPolicy.map(value => value.buildAwsValue()))(
        _.lookupPolicy
      )
      .optionallyWith(listIndex.map(value => value.buildAwsValue()))(
        _.listIndex
      )
      .optionallyWith(
        listOutgoingTypedLinks.map(value => value.buildAwsValue())
      )(_.listOutgoingTypedLinks)
      .optionallyWith(
        listIncomingTypedLinks.map(value => value.buildAwsValue())
      )(_.listIncomingTypedLinks)
      .optionallyWith(getLinkAttributes.map(value => value.buildAwsValue()))(
        _.getLinkAttributes
      )
      .optionallyWith(listObjectParents.map(value => value.buildAwsValue()))(
        _.listObjectParents
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadSuccessfulResponse
      .wrap(buildAwsValue())
}
object BatchReadSuccessfulResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadSuccessfulResponse =
      zio.aws.clouddirectory.model.BatchReadSuccessfulResponse(
        listObjectAttributes.map(value => value.asEditable),
        listObjectChildren.map(value => value.asEditable),
        getObjectInformation.map(value => value.asEditable),
        getObjectAttributes.map(value => value.asEditable),
        listAttachedIndices.map(value => value.asEditable),
        listObjectParentPaths.map(value => value.asEditable),
        listObjectPolicies.map(value => value.asEditable),
        listPolicyAttachments.map(value => value.asEditable),
        lookupPolicy.map(value => value.asEditable),
        listIndex.map(value => value.asEditable),
        listOutgoingTypedLinks.map(value => value.asEditable),
        listIncomingTypedLinks.map(value => value.asEditable),
        getLinkAttributes.map(value => value.asEditable),
        listObjectParents.map(value => value.asEditable)
      )
    def listObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse.ReadOnly
    ]
    def listObjectChildren: Optional[
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly
    ]
    def getObjectInformation: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly
    ]
    def getObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly
    ]
    def listAttachedIndices: Optional[
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly
    ]
    def listObjectParentPaths: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly
    ]
    def listObjectPolicies: Optional[
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.ReadOnly
    ]
    def listPolicyAttachments: Optional[
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse.ReadOnly
    ]
    def lookupPolicy: Optional[
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly
    ]
    def listIndex
        : Optional[zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly]
    def listOutgoingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly
    ]
    def listIncomingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly
    ]
    def getLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.ReadOnly
    ]
    def listObjectParents: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly
    ]
    def getListObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectAttributes", listObjectAttributes)
    def getListObjectChildren: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectChildren", listObjectChildren)
    def getGetObjectInformation: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectInformation", getObjectInformation)
    def getGetObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectAttributes", getObjectAttributes)
    def getListAttachedIndices: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listAttachedIndices", listAttachedIndices)
    def getListObjectParentPaths: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("listObjectParentPaths", listObjectParentPaths)
    def getListObjectPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectPolicies", listObjectPolicies)
    def getListPolicyAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("listPolicyAttachments", listPolicyAttachments)
    def getLookupPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly
    ] = AwsError.unwrapOptionField("lookupPolicy", lookupPolicy)
    def getListIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listIndex", listIndex)
    def getListOutgoingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listOutgoingTypedLinks",
      listOutgoingTypedLinks
    )
    def getListIncomingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listIncomingTypedLinks",
      listIncomingTypedLinks
    )
    def getGetLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("getLinkAttributes", getLinkAttributes)
    def getListObjectParents: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectParents", listObjectParents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
  ) extends zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly {
    override val listObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectAttributesResponse
          .wrap(value)
      )
    override val listObjectChildren: Optional[
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectChildren())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.wrap(value)
      )
    override val getObjectInformation: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getObjectInformation())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectInformationResponse
          .wrap(value)
      )
    override val getObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse
          .wrap(value)
      )
    override val listAttachedIndices: Optional[
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listAttachedIndices())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse
          .wrap(value)
      )
    override val listObjectParentPaths: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectParentPaths())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse
          .wrap(value)
      )
    override val listObjectPolicies: Optional[
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectPolicies())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.wrap(value)
      )
    override val listPolicyAttachments: Optional[
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listPolicyAttachments())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse
          .wrap(value)
      )
    override val lookupPolicy: Optional[
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lookupPolicy())
      .map(value =>
        zio.aws.clouddirectory.model.BatchLookupPolicyResponse.wrap(value)
      )
    override val listIndex: Optional[
      zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListIndexResponse.wrap(value)
      )
    override val listOutgoingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listOutgoingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse
          .wrap(value)
      )
    override val listIncomingTypedLinks: Optional[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listIncomingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse
          .wrap(value)
      )
    override val getLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.wrap(value)
      )
    override val listObjectParents: Optional[
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listObjectParents())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParentsResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
  ): zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly =
    new Wrapper(impl)
}
